/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console.scope;

import filenet.sim.toolkit.console.IVWSIMConsoleActionListener;
import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMConsoleActionCommand;
import filenet.sim.toolkit.console.VWSIMConsoleActionEvent;
import filenet.sim.toolkit.console.VWSIMConsolePerformer;
import filenet.sim.toolkit.console.VWSIMConsoleRootNode;
import filenet.sim.toolkit.console.VWSIMConsoleTreeCellRender;
import filenet.sim.toolkit.console.VWSIMFolderNode;
import filenet.sim.toolkit.console.scope.VWSIMConsoleScopeTree;
import filenet.sim.toolkit.console.scope.VWSIMScopeTreeMouseAdapter;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class VWSIMConsoleScopeViewPane
extends JScrollPane
implements TreeSelectionListener,
ActionListener,
IVWSIMConsoleActionListener {
    private Container m_parentContainer = null;
    private Frame m_parentFrame = null;
    private VWSIMConsoleScopeTree m_scopeTree = null;
    private VWSIMScopeTreeMouseAdapter m_scopeTreeMouseAdapter = null;
    private VWSIMBaseNode m_focus = null;
    private EventListenerList m_listenerList = null;
    private VWSIMConsolePerformer m_performer = null;
    private VWSIMConsoleRootNode m_root = null;
    private VWSIMConsoleTreeCellRender m_treeCellRender = null;
    private boolean m_fireFocusChangeEvent = true;

    public VWSIMConsoleScopeViewPane() {
        this.setDoubleBuffered(true);
        Dimension dim = VWStringUtils.stringToDimension("0,0");
        if (dim == null) {
            dim = new Dimension(0, 0);
        }
        this.setSize(dim.width, dim.height);
        this.m_listenerList = new EventListenerList();
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        this.setMinimumSize(new Dimension(0, 0));
        dim = VWStringUtils.stringToDimension("225,775");
        if (dim == null) {
            dim = new Dimension(200, 700);
        }
        this.setPreferredSize(dim);
    }

    public void init(VWSIMConsoleRootNode consoleRoot, Container parentContainer, Frame parentFrame, VWSIMConsolePerformer consolePeformer) {
        this.m_parentContainer = parentContainer;
        this.m_parentFrame = parentFrame;
        this.m_root = consoleRoot;
        this.m_focus = this.m_root;
        this.m_performer = consolePeformer;
        this.m_scopeTree = new VWSIMConsoleScopeTree(this.m_root, this.m_performer, this);
        this.m_scopeTree.getSelectionModel().setSelectionMode(1);
        this.m_scopeTree.addTreeSelectionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.m_scopeTree);
        this.m_treeCellRender = new VWSIMConsoleTreeCellRender();
        this.m_scopeTree.setCellRenderer(this.m_treeCellRender);
        this.m_scopeTreeMouseAdapter = new VWSIMScopeTreeMouseAdapter(this, this.m_scopeTree);
        this.m_scopeTree.addMouseListener(this.m_scopeTreeMouseAdapter);
        this.getViewport().add(this.m_scopeTree);
    }

    public void addConsoleActionListener(IVWSIMConsoleActionListener cal) {
        this.m_listenerList.add(IVWSIMConsoleActionListener.class, cal);
    }

    private void collapsePath(VWSIMBaseNode aNode) {
        this.m_fireFocusChangeEvent = false;
        TreePath treePath = new TreePath(aNode.getPath());
        this.m_scopeTree.collapsePath(treePath);
        this.m_fireFocusChangeEvent = true;
    }

    private void setSelectedPath(VWSIMBaseNode aNode) {
        this.m_fireFocusChangeEvent = false;
        TreePath treePath = new TreePath(aNode.getPath());
        this.m_scopeTree.setSelectionPath(treePath);
        this.m_fireFocusChangeEvent = true;
    }

    private void expandScopeTree(VWSIMBaseNode aNode) {
        this.m_fireFocusChangeEvent = false;
        TreePath treePath = new TreePath(aNode.getPath());
        this.m_scopeTree.setSelectionPath(treePath);
        this.m_scopeTree.expandPath(treePath);
        this.m_fireFocusChangeEvent = true;
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath selPath = null;
        Object obj = null;
        VWSIMBaseNode baseNode = null;
        selPath = event.getNewLeadSelectionPath();
        if (selPath == null) {
            return;
        }
        baseNode = (VWSIMBaseNode)selPath.getLastPathComponent();
        if (baseNode == null) {
            return;
        }
        this.setFocus(baseNode);
        if (this.m_fireFocusChangeEvent) {
            this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 48));
        }
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_HELP) == 0) {
                this.m_performer.performHelp(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_MAP_FOLDER) == 0) {
                if (this.m_performer.performMapCeFolder(this.m_focus)) {
                    this.m_scopeTree.refresh();
                    this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 32));
                }
            } else if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_REFRESH) == 0) {
                if (this.m_focus.isFolderNode()) {
                    VWSIMFolderNode aFolderNode = (VWSIMFolderNode)this.m_focus;
                    aFolderNode.getSubFolders(true);
                    aFolderNode.refreshSubFolderContents();
                    this.m_scopeTree.refresh();
                    this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 32));
                }
            } else if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_DISCONNECT_MAP_FOLDER) == 0) {
                VWSIMBaseNode parentNode = (VWSIMBaseNode)this.m_focus.getParent();
                this.disconnectMappedFolder(this.m_focus);
                this.setFocus(parentNode);
                this.expandScopeTree(this.m_focus);
                this.updateUI();
                this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 48));
            } else if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_SET_FOCUS) == 0) {
                this.fireConsoleActionEvent(new VWSIMConsoleActionEvent(this, this.m_focus, 16));
            } else if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_PROPERTIES) == 0) {
                this.m_performer.performProperties(this.m_focus);
            } else if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_PUBLISHED_DATA) == 0) {
                this.m_performer.publishedData();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consoleActionPerformed(VWSIMConsoleActionEvent evt) {
        VWSIMBaseNode baseNode = evt.getBaseNode();
        int consoleAction = evt.getAction();
        try {
            if (evt.disconnectMappedFolder()) {
                this.disconnectMappedFolder(baseNode);
            }
            if (evt.setFocus()) {
                if (baseNode.getType() == 33 || baseNode.getType() == 34) {
                    this.m_scopeTree.setSelectionActive(false);
                    this.updateUI();
                } else {
                    this.m_fireFocusChangeEvent = false;
                    this.setFocus(baseNode);
                    this.m_scopeTree.setSelectionActive(true);
                    this.expandScopeTree(this.m_focus);
                    this.updateUI();
                    this.m_fireFocusChangeEvent = true;
                }
            }
            if (evt.expandTree()) {
                this.expandScopeTree(this.m_focus);
            }
            if (evt.refresh() && baseNode.isFolderNode()) {
                VWSIMFolderNode aFolderNode = (VWSIMFolderNode)baseNode;
                aFolderNode.getSubFolders(true);
                aFolderNode.refreshSubFolderContents();
                this.m_fireFocusChangeEvent = false;
                this.m_scopeTree.refresh();
                this.m_fireFocusChangeEvent = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_fireFocusChangeEvent = true;
        }
    }

    public void disconnectMappedFolder(VWSIMBaseNode mappedFolder) {
        if (mappedFolder.getType() != 18) {
            return;
        }
        this.m_root.deleteMappedFolder(this.m_focus.getIdmItem());
        this.m_fireFocusChangeEvent = false;
        mappedFolder.removeFromParent();
        this.m_scopeTree.updateUI();
        this.m_fireFocusChangeEvent = true;
    }

    protected void fireConsoleActionEvent(VWSIMConsoleActionEvent evt) {
        if (evt == null) {
            return;
        }
        Object[] listeners = this.m_listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IVWSIMConsoleActionListener.class) continue;
            ((IVWSIMConsoleActionListener)listeners[i + 1]).consoleActionPerformed(evt);
        }
    }

    protected VWSIMBaseNode getFocus() {
        return this.m_focus;
    }

    private void setFocus(VWSIMBaseNode focus) {
        this.m_focus = focus;
        this.m_scopeTree.setFocus(this.m_focus);
        this.m_scopeTreeMouseAdapter.setFocus(this.m_focus);
    }

    protected void releaseResources() {
        this.m_parentContainer = null;
        this.m_parentFrame = null;
        if (this.m_treeCellRender != null) {
            this.m_treeCellRender.removeAll();
            this.m_treeCellRender = null;
        }
        if (this.m_scopeTree != null) {
            this.m_scopeTree.releaseResources();
            this.m_scopeTree.removeTreeSelectionListener(this);
            this.m_scopeTree.setSelectionPath(null);
            this.m_scopeTree.setCellRenderer(null);
            this.m_scopeTree.removeAll();
            this.m_scopeTree = null;
        }
        if (this.m_scopeTreeMouseAdapter != null) {
            this.m_scopeTreeMouseAdapter.releaseResources();
            this.m_scopeTreeMouseAdapter = null;
        }
        this.m_focus = null;
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                this.m_listenerList.remove(IVWSIMConsoleActionListener.class, (IVWSIMConsoleActionListener)listeners[i + 1]);
                listeners[i] = null;
                listeners[i + 1] = null;
            }
            this.m_listenerList = null;
        }
        this.m_performer = null;
        this.m_root = null;
        this.removeAll();
    }
}

